/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.syncing.ui.old;

import com.aptana.core.logging.IdeLog;
import com.aptana.ide.syncing.ui.SyncingUIPlugin;
import com.aptana.ide.syncing.ui.old.Messages;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class SyncingConsole
extends MessageConsole {
    private static SyncingConsole _console;
    private MessageConsoleStream _consoleStream = this.newMessageStream();

    public SyncingConsole(String name, ImageDescriptor imageDescriptor) {
        super(name, imageDescriptor);
    }

    public MessageConsoleStream getMessageStream() {
        return this._consoleStream;
    }

    public static SyncingConsole getConsole() {
        if (_console == null) {
            SyncingConsole.initConsole();
        }
        return _console;
    }

    private static void initConsole() {
        _console = new SyncingConsole(Messages.SyncingConsole_AptanaSyncingConsole, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{_console});
    }

    public static void println(String message) {
        try {
            SyncingConsole console = SyncingConsole.getConsole();
            if (console != null) {
                MessageConsoleStream ms = console.getMessageStream();
                ms.write(message);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)SyncingUIPlugin.getDefault(), (String)MessageFormat.format(Messages.SyncingConsole_UnableToWriteToConsole, message), (Throwable)e);
        }
    }

    protected void dispose() {
        super.dispose();
        try {
            this._consoleStream.close();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)SyncingUIPlugin.getDefault(), (String)Messages.SyncingConsole_ErrorClosingStream, (Throwable)e);
        }
    }
}

